/*
 * shmread.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Read a shared memory segment with the given id
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <sys/shm.h>
#include <ipc_secure.h>

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage:  %s -i id [-o offset] [-l length]\n", progname);
  exit(1);
}

int main(int argc, char **argv)
{
  int id, got_id = 0;
  char *message;
  int offset = 0, length=256;
  int err, ret;
  char *mem_seg;
  char c;

  while ( (c = getopt(argc, argv, "o:i:l:")) != EOF) {
    switch (c) {
    case 'o':
      offset = atoi(optarg);
      break;
    case 'i':
      id = atoi(optarg);
      got_id = 1;
      break;
    case 'l':
      length = atoi(optarg);
      break;
    default:
      usage(argv[0]);
    }
  }
  if (! got_id) {
    fprintf (stderr, "Shared memory segment ID (-i) is required.\n");
    usage(argv[0]);
  }

  message = (char *)malloc (length+1);
  strcpy (message, "String copy failed.......................");
  fprintf (stderr, "%s: about to attach to segment\n", argv[0]);
  if ((mem_seg = (char *)shmat(id, (void *)0, SHM_RDONLY)) < 0)
    perror ("shmat failed");
  else {
    fprintf (stderr, "%s: shmat succeeded, about to read message\n",argv[0]);
    strncpy (message, mem_seg+offset, length);

    /* msgwrite.c should have done this, but let's be safe. */
    message[length]='\0';

    fprintf (stderr, "%s: about to detach from segment\n",argv[0]);
    if (shmdt(mem_seg) < 0)
      perror ("shmdt failed");
    else
      fprintf (stderr, "shmdt succeeded\n");
    fprintf (stderr, "Shared memory message read was:\n%s\n", message);
    return;
  }
  free (message);
}


