/*
 * shmwrite.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Write to a shared memory segment with the given id
 *
 */

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <getopt.h>
#include <linux/flask/flask.h>
#include <sys/shm.h>
#include <ipc_secure.h>

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage:  %s -i id [-o offset] [-l length] < message\n", progname);
  exit(1);
}

int main(int argc, char **argv)
{
  int id, got_id = 0;
  char *message, *first_words, *word;
  int offset = 0, length=256;
  char *mem_seg;
  char c;

  while ( (c = getopt(argc, argv, "o:i:l:")) != EOF) {
    switch (c) {
    case 'o':
      offset = atoi(optarg);
      break;
    case 'i':
      id = atoi(optarg);
      got_id = 1;
      break;
    case 'l':
      length = atoi(optarg);
      break;
    default:
      usage(argv[0]);
    }
  }
  if (! got_id) {
    fprintf (stderr, "Shared memory segment ID (-i) is required.\n");
    usage(argv[0]);
  }

  first_words = (char *) malloc (strlen (""));
  word = (char *) malloc (20);
  strcpy (first_words, "");
  message = (char *) malloc (strlen (""));
  strcpy (message, "");
  while (scanf ("%20s", word) != EOF) {
    first_words = message;
    message = (char *) malloc (strlen (first_words) + strlen (word) + 2);
    strcpy (message, first_words);
    strcat (message, " ");
    strcat (message, word);
    free (first_words);
  }
  free (word);

  fprintf (stderr, "%s: about to attach to segment\n", argv[0]);
  if ((mem_seg = (char *)shmat(id, (void *)0, 0)) < 0)
    perror ("shmat failed");
  else {
    fprintf (stderr, "%s: shmat succeeded, about to write message\n",argv[0]);
    strcpy (mem_seg, message);
    fprintf (stderr, "%s: about to detach from segment\n",argv[0]);
    if (shmdt(mem_seg) < 0)
      perror ("shmdt failed");
    else
      fprintf (stderr, "shmdt succeeded\n");
    fprintf (stderr, "Shared memory message written was:\n%s\n", message);
    return;
  }
  free (message);
}


