#include <fs_secure.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  struct stat sb;
  security_id_t sid;
  char modebuf[11];

  
  if (argc != 2) {
    printf("usage:  %s pathname\n", argv[0]);
    exit(1);
  }
  
  if (stat_secure(argv[1], &sb, &sid) < 0) {
    perror(argv[1]);
    exit(2);
  }

  memset(modebuf, 0, sizeof modebuf);
  mode_string(sb.st_mode, &modebuf);

  printf("%s  %d  %d  %d  *%d*  %d  ",
	 modebuf,
	 sb.st_nlink,
	 sb.st_uid, 
	 sb.st_gid, 
	 sid,
	 sb.st_size);
  printf("%s", ctime(&sb.st_mtime));
  exit(0);
}
