/* statfs_secure.c
 *
 * returns information about a mounted file system
 */

#include <fs_secure.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  struct statfs buf;
  security_id_t sid;
  char scontext[256];
  int cntxtlen = 256;
  
  if (argc != 2) {
    printf("usage:  %s pathname\n", argv[0]);
    exit(1);
  }
  
  if (statfs_secure(argv[1], &buf, &sid) < 0) {
    perror(argv[1]);
    exit(2);
  }
  
  if (security_sid_to_context (sid, scontext, &cntxtlen) != 0) {
    perror ("security_sid_to_context");
    exit(2);
  }
  printf("blocks: %ld, available: %ld, sid *%d*\n",
	 buf.f_blocks, buf.f_bavail, sid);
  printf ("context: %s\n", scontext);
  
  exit(0);
}
