/* GNU's read utmp module.
   Copyright (C) 1992-1999 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by jla; revised by djm */

#include <config.h>

#include <stdio.h>

#include <sys/stat.h>
#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
# include <string.h>
#else
# include <strings.h>
#endif /* STDC_HEADERS || HAVE_STRING_H */

#include "readutmp.h"

char *xmalloc ();
char *realloc ();
char *xrealloc();

/* Copy UT->ut_name into storage obtained from malloc.  Then remove any
   trailing spaces from the copy, NUL terminate it, and return the copy.  */

char *
extract_trimmed_name (const STRUCT_UTMP *ut)
{
  char *p, *trimmed_name;

  trimmed_name = xmalloc (sizeof (ut->ut_name) + 1);
  strncpy (trimmed_name, ut->ut_name, sizeof (ut->ut_name));
  /* Append a trailing space character.  Some systems pad names shorter than
     the maximum with spaces, others pad with NULs.  Remove any spaces.  */
  trimmed_name[sizeof (ut->ut_name)] = ' ';
  p = strchr (trimmed_name, ' ');
  if (p != NULL)
    *p = '\0';
  return trimmed_name;
}

/* Read the utmp entries corresponding to file FILENAME into freshly-
   malloc'd storage, set *UTMP_BUF to that pointer, set *N_ENTRIES to
   the number of entries, and return zero.  If there is any error,
   return non-zero and don't modify the parameters.  */

#if HAVE_UTMPNAME

int
read_utmp (const char *filename, int *n_entries, STRUCT_UTMP **utmp_buf)
{
  int n_read;
  STRUCT_UTMP *u;
  STRUCT_UTMP *utmp = NULL;

  /* Ignore the return value for now.
     Solaris' utmpname returns 1 upon success -- which is contrary
     to what the GNU libc version does.  In addition, older GNU libc
     versions are actually void.   */
  UTMP_NAME_FUNCTION (filename);

  SET_UTMP_ENT ();

  n_read = 0;
  while ((u = GET_UTMP_ENT ()) != NULL)
    {
      ++n_read;
      utmp = (STRUCT_UTMP *) realloc (utmp, n_read * sizeof (STRUCT_UTMP));
      if (utmp == NULL)
	return 1;
      utmp[n_read - 1] = *u;
    }

  END_UTMP_ENT ();

  *n_entries = n_read;
  *utmp_buf = utmp;

  return 0;
}

#else
#define UTMP_READ_INCR 128

int
read_utmp (const char *filename, int *n_entries, STRUCT_UTMP **utmp_buf)
{
    int n_read;
    STRUCT_UTMP *uptr;

    utmpname(filename);
    setutent();
    n_read = 0;
    utmp_contents = (STRUCT_UTMP *) xmalloc(UTMP_READ_INCR*sizeof(STRUCT_UTMP));
    while ((uptr=getutent())) {
	if (NULL == utmp_contents)
	    break;  /* we do not have more memory here */
	memcpy(&utmp_contents[n_read], uptr, sizeof(STRUCT_UTMP));
	n_read++;
	if (0 == ( n_read % UTMP_READ_INCR ))
	    utmp_contents = (STRUCT_UTMP *)
		xrealloc(utmp_contents,
			 (n_read + UTMP_READ_INCR) * sizeof(STRUCT_UTMP));
    }
   
    endutent();
    return n_read;
}

#endif /* HAVE_UTMPNAME */
