/**************************************************************************** 
** File: ip.c
**
** Author: Mike Borella
**
** Comments: Dump IP header information
**
*****************************************************************************/

#include "global.h"
#include "protocols.h"

extern struct arg_t *my_args;
extern void (*ip_proto_func[])(packet_t *);
extern strmap_t ipproto_map[];

/*----------------------------------------------------------------------------
**
** dump_ipv6()
**
** Parse IPv6 header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_ipv6(packet_t *pkt)
{
  ipv6_header ipv6;
  char        holder[64];
  u_int8_t    ver;
  u_int8_t    class; 
  u_int32_t   flow;

  /*
   * Get the IPv6 header
   */

  if (get_packet_bytes((u_int8_t *) &ipv6, pkt, 40) == 0)
    return;

  /*
   * Conversions
   */

  ver = ipv6.version;
  class = ipv6.traffic_class;
  flow = ipv6.flow_label;

  /*
   * Dump header
   */

  if (my_args->m)
    {
      display_minimal((u_int8_t *) &ipv6.src_addr, 16, DISP_HEXCOLONS4); 
      display_minimal("->", 2, DISP_STRING);
      display_minimal((u_int8_t *) &ipv6.dst_addr, 16, DISP_HEXCOLONS4); 
      display_minimal(" ", 1, DISP_STRING);
    }
  else
    if (!my_args->n)
      {
	/* announcement */
	display_header_banner("IPv6 Header");
	
	/* print fields */
	display("Version", (u_int8_t *) &ver, 1, DISP_1BYTEDEC);
	display("Traffic class", (u_int8_t *) &class, 1, DISP_HEX);
	display("Flow label", (u_int8_t *) &flow, 4, DISP_HEX);
	display("Payload length", (u_int8_t *) &ipv6.payload_length, 2, 
		DISP_2BYTEDEC);
	sprintf(holder, "%d (%s)", ipv6.next_header, 
		map2str(ipproto_map, ipv6.next_header));
	display("Next header", holder, strlen(holder), DISP_STRING);
	display("Hop limit", (u_int8_t *) &ipv6.hop_limit, 1, DISP_1BYTEDEC);
	display("Source address",(u_int8_t *) &ipv6.src_addr, 16, 
		DISP_HEXCOLONS4); 
	display("Destination address",(u_int8_t *) &ipv6.dst_addr, 16, 
		DISP_HEXCOLONS4); 
      }

  /*
   * Hand it to the next higher level protocol.
   */
  
  if (ip_proto_func[ipv6.next_header]) 
    ip_proto_func[ipv6.next_header](pkt);
}

