/**************************************************************************** 
** File: ipv6.h
**
** Author: Mike Borella
**
** Comments: Generic IPv6 header structure.
**
** $Log: ipv6.h,v $
** Revision 1.2  2000/05/11 21:52:49  mborella
** Trying to figure out what's wrong with these files - each of them
** always claims to be modified...
**
*****************************************************************************/

#ifndef IPV6_H
#define IPV6_H

#include "global.h"

typedef struct ipv6_header
{
#if defined(WORDS_BIGENDIAN)
  u_int32_t      version:4, 
                 traffic_class:8, 
                 flow_label:20;
#else
  u_int32_t      flow_label:20,
                 traffic_class:8,
                 version:4;
#endif
  u_int16_t      payload_length;
  u_int8_t       next_header;
  u_int8_t       hop_limit;
  u_int8_t       src_addr[16];
  u_int8_t       dst_addr[16];
} ipv6_header;

void dump_ipv6(packet_t *);

#endif
