/**************************************************************************** 
** File: ipxrip.c
**
** Author: Mike Borella
**
** Comments: Dump IPX/RIP header information
**
** $Log: ipxrip.c,v $
** Revision 1.2  2000/05/09 17:16:43  mborella
** Fixed new minimal more for IPX, IPX RIP and ARP.
**
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.3  2000/05/04 18:49:11  mborella
** Fixed IPX RIP.
**
** Revision 1.2  2000/05/04 00:25:10  mborella
** Updated IPX for new API.  IPX RIP and SPX are now slightly broken.
** You've been warned...
**
** Revision 1.1.1.1  2000/04/11 17:26:17  mborella
** Initial checkin of release 0.8.2 code.
**
** Revision 1.2  1998/06/12 21:01:09  mborella
** Added log tag
**
*****************************************************************************/

#include <stdio.h>
#include "global.h"
#include "protocols.h"

strmap_t ipxrip_command_map [] =
{
  { IPXRIP_COMMAND_REQUEST,   "request" },
  { IPXRIP_COMMAND_RESPONSE,  "response" }
};

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_ipxrip()
**
** Parse IPX/RIP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_ipxrip(packet_t *pkt)
{
  ipxrip_header_t  rip;
  ipxrip_entry_t   e;
  char holder[64];
  u_int8_t count = 0;
 
  /*
   * Get the IPX RIP header
   */

  if (get_packet_bytes((u_int8_t *) &rip, pkt, sizeof(ipxrip_header_t)) 
		       == 0)
    return;

  /*
   * Conversions
   */

  rip.op = ntohs(rip.op);

  /*
   * Dump header
   */

  if (my_args->m && !my_args->t)
    {
      /* what to do with minimal mode here?? */
      return;
    }
  else
    if (!my_args->t)
      {
	/* announcement */
	display_header_banner("IPX RIP Header");
       
	/* operation */
	sprintf(holder, "%d (%s)", rip.op, map2str(ipxrip_command_map, 
						   rip.op));
	display("Operation", (u_int8_t *) holder, strlen(holder), DISP_STRING);

	/*
	 * Loop forever dumping routing entries.  Get_packet_bytes() failing
	 * kicks us out when the time comes.
	 */
	
	while(1)
	  {
	    /* Get the entry */
	    if (get_packet_bytes((u_int8_t *) &e, pkt, sizeof(ipxrip_entry_t)) 
		== 0)
	      return;
	    
	    /* increment count */
	    count++;
	    
	    /* do conversions */
	    e.net = htonl(e.net);
	    e.hops = htons(e.hops);
	    e.ticks = htons(e.ticks);
	    
	    /* Show the route */
	    display("Route", (u_int8_t *) &count, 1, DISP_1BYTEDEC);
	    display("  Network", (u_int8_t *) &e.net, 4, DISP_HEX);
	    display("  Hops", (u_int8_t *) &e.hops, 2, DISP_2BYTEDEC);
	    display("  Ticks", (u_int8_t *) &e.ticks, 2, DISP_2BYTEDEC);
	  }
      } /* if */
  
}


