/**************************************************************************** 
** File: mgcp.c
**
** Author: Cullen Jennings & Mike Borella
**
** Comments: Dump MGCP header information. I didn't try to do anything
** fancy with this - I just dump the plaintext 
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "global.h"
#include "protocols.h"

#define LINE_SIZE 256
#define FALSE 0
#define TRUE  1

/*----------------------------------------------------------------------------
**
** is_mgcp()
**
** Return true if this udp packet is a MGCP packet 
**
**----------------------------------------------------------------------------
*/

int is_mgcp(packet_t *pkt)
{
   if ( 0 < 4 ) return 0; /* FIXME!!*/

   if ( !strncmp(pkt,"EPCF",4) ) return 1;
   if ( !strncmp(pkt,"RQNT",4) ) return 1;
   if ( !strncmp(pkt,"NTFY",4) ) return 1;
   if ( !strncmp(pkt,"CRCX",4) ) return 1;
   if ( !strncmp(pkt,"MDCX",4) ) return 1;
   if ( !strncmp(pkt,"DLCX",4) ) return 1;
   if ( !strncmp(pkt,"AUEP",4) ) return 1;
   if ( !strncmp(pkt,"AUCX",4) ) return 1;
   if ( !strncmp(pkt,"RSIP",4) ) return 1;

   return 0;
}


/*----------------------------------------------------------------------------
**
** dump_mgcp()
**
** Parse MGCP packet and dump fields. 
**
**----------------------------------------------------------------------------
*/

void dump_mgcp(packet_t *pkt)
{
  char line[LINE_SIZE];
  int n = 0;
  int get_next_line(u_char *, u_char *, char *);

  printf("-----------------------------------------------------------------\n");
  printf("                        MGCP \n");
  printf("-----------------------------------------------------------------\n");

  while(p <= ep && (n = get_next_line(p, ep, line)))
    {
      p = p + n;
      length = length - n;

      printf("%s\n", line);
    }
}

