/**************************************************************************** 
** File: spx.c
**
** Author: Mike Borella
**
** Comments: Dump SPX header information
**
** $Log: spx.c,v $
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.3  2000/05/04 18:21:10  mborella
** Fixed SPX.
**
** Revision 1.2  2000/05/04 00:25:10  mborella
** Updated IPX for new API.  IPX RIP and SPX are now slightly broken.
** You've been warned...
**
** Revision 1.1.1.1  2000/04/11 17:26:16  mborella
** Initial checkin of release 0.8.2 code.
**
** Revision 1.2  1998/06/12 21:01:14  mborella
** Added log tag
**
*****************************************************************************/

#include <stdio.h>
#include "global.h"
#include "protocols.h"

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_spx()
**
** Parse SPX header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_spx(packet_t *pkt)
{
  spx_header_t spx;

  /*
   * Get the SPX header
   */

  if (get_packet_bytes((u_int8_t *) &spx, pkt, 12) == 0)
    return;

  /*
   * Conversions
   */

  spx.s_id = ntohs(spx.s_id);
  spx.d_id = ntohs(spx.d_id);
  spx.seqno = ntohs(spx.seqno);
  spx.ackno = ntohs(spx.ackno);
  spx.allocno = ntohs(spx.allocno);
  
  /*
   * Dump header
   */
 
  if (!my_args->n)
    {
      /* announcement */
      display_header_banner("SPX Header");

      /* fields */
      display("Connection control", (u_int8_t *) &spx.cc, 1, DISP_1BYTEDEC);
      display("Data stream type", (u_int8_t *) &spx.ds_type, 1, DISP_1BYTEDEC);
      display("Source conn ID", (u_int8_t *) &spx.s_id, 2, DISP_2BYTEDEC);
      display("Dest conn ID", (u_int8_t *) &spx.d_id, 2, DISP_2BYTEDEC);
      display("Sequence number", (u_int8_t *) &spx.seqno, 2, DISP_2BYTEDEC);
      display("Ack number", (u_int8_t *) &spx.ackno, 2, DISP_2BYTEDEC);
      display("Allocation number", (u_int8_t *) &spx.allocno, 2, 
	      DISP_2BYTEDEC);
    }


}
