/**************************************************************************** 
** File: ah.c
**
** Author: Mike Borella
**
** Dump AH payload
**
** $Log: ah.c,v $
** Revision 1.2  2000/05/08 23:36:04  mborella
** Got rid of addrtoname.c module.  Functionality is now taken care of in our
** own way.
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "global.h"
#include "protocols.h"
#include "addrtoname.h"

extern struct arg_t *my_args;
extern void (*ip_proto_func[])(packet_t *);
extern strmap_t ipproto_map[];

/*----------------------------------------------------------------------------
**
** dump_ah()
**
** Parse AH packet and dump fields.
**
**----------------------------------------------------------------------------
*/

void dump_ah(packet_t *pkt)
{
  ah_header_t ah;
  char        holder[256];
  u_int16_t   ad_length;
  u_int8_t    len;
  u_int8_t    next;
  u_int16_t   reserved;

  /*
   * Get the AH header
   */

  if (get_packet_bytes((u_int8_t *) &ah, pkt, 12) == 0)
    return;

  /*
   * Conversions
   */

  len = ah.length;
  next = ah.next;
  reserved = ah.reserved;
  ah.spi = ntohl(ah.spi);
  ah.seqno = ntohl(ah.seqno);

  /*
   * Figure out length of authentication data, hoping its not too big...
   */

  ad_length = len * 4 - 12;
  if (get_packet_bytes((u_int8_t *) &holder, pkt, ad_length) == 0)
    return;
  

  /*
   * Dump header
   */

  if (my_args->m)
    {
      display_minimal((u_int8_t *) &ah.spi, 4, DISP_HEX); 
      display_minimal(" ", 1, DISP_STRING);
    }
  else
    if (!my_args->n)
      {
        /* announcement */
        display_header_banner("Authentication Header");
        
        /* print fields */
        sprintf(holder, "%d (%s)", next, map2str(ipproto_map, next));
        display("Next header", holder, strlen(holder), DISP_STRING);
        display("Reseerved", (u_int8_t *) &reserved, 2, DISP_2BYTEDEC);
        display("Header length", (u_int8_t *) &len, 1, DISP_1BYTEDEC);
	display("SPI", (u_int8_t *) &ah.spi, 4, DISP_HEX); 
        display("Sequence number", (u_int8_t *) &ah.seqno, 4, DISP_4BYTEDEC);
      }
	
  /*
   * Figure out the next header
   */
  
  if (ip_proto_func[ah.next])
    ip_proto_func[ah.next](pkt);
  
}
