/**************************************************************************** 
 ** File: dns.h
 **
 ** Author: Mike Borella
 **
 ** Comments: Structure of the first 12 bytes of DNS packets
 **
 ** $Log: dns.h,v $
 ** Revision 1.2  2000/05/09 22:49:35  mborella
 ** Added documentation files.  Enabled DHCP and DNS output.  Trying to fix
 ** DHCP output.
 **
 ****************************************************************************/

#ifndef DNS_H
#define DNS_H

#include "global.h"

typedef struct dns_header
{
  u_int16_t dns_id;
#if defined (WORDS_BIGENDIAN)
  u_int16_t dns_fl_qr:1,
            dns_fl_opcode:4,
            dns_fl_aa:1,
            dns_fl_tc:1,
            dns_fl_rd:1,
            dns_fl_ra:1,
            dns_fl_zero:3,
            dns_fl_rcode:4;
#else
  u_int16_t dns_fl_rcode:4,
            dns_fl_zero:3,
            dns_fl_ra:1,
            dns_fl_rd:1,
            dns_fl_tc:1,
            dns_fl_aa:1,
            dns_fl_opcode:4,
            dns_fl_qr:1;
#endif
  u_int16_t dns_num_q;
  u_int16_t dns_num_ans;
  u_int16_t dns_num_auth;
  u_int16_t dns_num_add;
} dns_header_t;

void dump_dns(packet_t *);

#endif
