/**************************************************************************** 
** File: esp.c
**
** Author: Mike Borella
**
** Comments: Dump ESP header information. Since this packet sniffer
** is stateless, we cannot determine any headers besides the SPI and the
** sequence number.  In order to figure out the padding length and next 
** payload headers we would need to know the authentication mechanism 
** (if any) used for this SA.  But that info is part of the ISAKMP
** negotiation rather than the ESP header.  Oh well.
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "global.h"
#include "protocols.h"

/*----------------------------------------------------------------------------
**
** dump_esp()
**
** Parse ESP packet and dump fields.
**
**----------------------------------------------------------------------------
*/

void dump_esp(packet_t *pkt)
{
  esp_header_t *esp;

  esp = (esp_header_t *) pkt->current;

  printf("-----------------------------------------------------------------\n");
  printf("                        ESP Header\n");
  printf("-----------------------------------------------------------------\n");
  
  printf("SPI:                    %d\n", ntohl(esp->spi));
  printf("Sequence number:        %d\n", ntohl(esp->seqno));

}

