/**************************************************************************** 
** File: ethernet.h
**
** Author: Mike Borella
**
** Comments: Generic ethernet structure - an attempt at OS independence
**
** $Log: ethernet.h,v $
** Revision 1.2  2000/05/09 17:43:47  mborella
** Made some fixes to minimal mode ethernet, so that the ethernet type field
** is always displayed.  However, the results are weird...
**
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.5  2000/04/17 23:20:00  mborella
** Minor fixes to Ethernet, rudimentary support for IP options.
**
** Revision 1.4  2000/04/16 23:28:46  mborella
** This is a major update, maoving the base IP stack protocols to the new
** generic reading and writing system.  Some stuff is still broken.
**
** Revision 1.3  2000/04/13 20:19:53  mborella
** Added more generic display features, cleaned up more cruft.
**
** Revision 1.2  2000/04/13 16:42:08  mborella
** Added support to some protocols for using generic header banners
**
** Revision 1.1.1.1  2000/04/11 17:26:16  mborella
** Initial checkin of release 0.8.2 code.
**
*****************************************************************************/

#ifndef ETHERNET_H
#define ETHERNET_H

#define ETHERNET_TYPE_IP        0x0800  /* IPv4 */
#define ETHERNET_TYPE_ARP       0x0806  /* Addr. resolution protocol */
#define ETHERNET_TYPE_RARP      0x8035  /* Reverse addr. resolution protocol */
#define ETHERNET_TYPE_IPX       0x8137  /* IPX family */
#define ETHERNET_TYPE_IPV6      0x86dd  /* IPv6 */

#define ETHERMTU                1500

/*
 * Ethernet header
 */

typedef struct ether_header
{
  u_int8_t  dst[6];
  u_int8_t  src[6];
  u_int16_t type;
} ether_header_t;

void dump_ethernet(packet_t *);

#endif



