/**************************************************************************** 
** File: ip_protocols.h
**
** Author: Mike Borella
**
** Comments: IP next protocol numbers
**
*****************************************************************************/

#ifndef IP_PROTOCOLS_H
#define IP_PROTOCOLS_H

#include "global.h"

/* 
 * This list contains lots of crufty old protocols just for kicks.
 * The complete list is at http://www.iana.org.
 */

#define PROTO_IPV6HOP    0
#define PROTO_ICMP       1
#define PROTO_IGMP       2
#define PROTO_GGP        3
#define PROTO_IPENCAP    4
#define PROTO_ST         5
#define PROTO_TCP        6
#define PROTO_CBT        7
#define PROTO_EGP        8
#define PROTO_IGP        9
#define PROTO_PUP        12
#define PROTO_UDP        17
#define PROTO_HMP        20
#define PROTO_XNSIDP     22
#define PROTO_RDP        27
#define PROTO_IPV6       41
#define PROTO_IPV6ROUTE  43
#define PROTO_IPV6FRAG   44
#define PROTO_IDRP       45
#define PROTO_RSVP       46
#define PROTO_ESP        50
#define PROTO_AH         51
#define PROTO_NARP       54
#define PROTO_IPV6ICMP   58
#define PROTO_IPV6NONEXT 59

/*
 * List of well-known and non-so-well-known port numbers - NOT DONE YET!
 */

#define PORT_TCPMUX            1
#define PORT_ECHO              7
#define PORT_DISCARD           9
#define PORT_SYSTAT            11
#define PORT_DAYTIME           13
#define PORT_NETSTAT           15
#define PORT_QOTD              17
#define PORT_MSP               18
#define PORT_CHARGEN           19
#define PORT_FTPDATA           20
#define PORT_FTPCTRL           21
#define PORT_SSH               22
#define PORT_TELNET            23
#define PORT_SMTP              25
#define PORT_TIME              37
#define PORT_RLP               39
#define PORT_NAMESERVER        42
#define PORT_WHOIS             43
#define PORT_REMOTEMAILCHECK   50
#define PORT_DNS               53
#define PORT_MTP               57
#define PORT_DHCPSERVER        67
#define PORT_DHCPCLIENT        68
#define PORT_TFTP              69
#define PORT_GOPHER            70
#define PORT_RJE               77
#define PORT_FINGER            79
#define PORT_HTTP              80
#define PORT_TTYLINK           87
#define PORT_KERBEROS          88
#define PORT_SUPDUP            95
#define PORT_HOSTNAMES         101
#define PORT_ISOTSAP           102
#define PORT_CSNETNAMESERVICE  105
#define PORT_EUDORA            106
#define PORT_RTELNET           107
#define PORT_POP2              109
#define PORT_POP3              110
#define PORT_SUNRPC            111
#define PORT_AUTH              113
#define PORT_SFTP              115
#define PORT_UUCPPATH          117
#define PORT_NETBIOSNS         137
#define PORT_NETBIOSDGM        138
#define PORT_NETBIOSSSN        139
#define PORT_IMAP2             143
#define PORT_SNMP              161
#define PORT_SNMPTRAP          162
#define PORT_CMIPMAN           163
#define PORT_CMIPAGENT         164
#define PORT_XDMCP             177
#define PORT_NEXTSTEP          178
#define PORT_BGP               179
#define PORT_PROSPERO          191
#define PORT_IRC               194
#define PORT_SMUX              199
#define PORT_APPLETALKRTMP     201
#define PORT_APPLETALKNBP      202
#define PORT_APPLETALKECHO     204
#define PORT_APPLETALKZIS      206
#define PORT_QMTP              209
#define PORT_Z3950             210
#define PORT_IPX               213
#define PORT_IMAP3             220
#define PORT_RPC2PORTMAP       369
#define PORT_CODAAUTH2         370
#define PORT_UNIXLISTSERV      372
#define PORT_SERVERLOCATION    427
#define PORT_HTTPS             443
#define PORT_SNPP              444
#define PORT_SAFT              487
#define PORT_EXECBIFF          512
#define PORT_LOGIN             513
#define PORT_WHO               514
#define PORT_PRINTER           515
#define PORT_TALK              517
#define PORT_NTALK             518
#define PORT_RIP               520
#define PORT_TIMED             525
#define PORT_TEMPO             526
#define PORT_COURIER           530
#define PORT_CONFERENCE        531
#define PORT_NETNEWS           532
#define PORT_NETWALL           533
#define PORT_UUCP              540
#define PORT_KLOGIN            543
#define PORT_KSHELL            544
#define PORT_AFPOVERTCP        548
#define PORT_REMOTEFS          556
#define PORT_NPMPLOCAL         610
#define PORT_NPMPGUI           611
#define PORT_HMMPIND           612
#define PORT_KERBEROSADM       749
#define PORT_WEBSTER           765

#define PORT_INGRESLOCK        1524
#define PORT_PROSPERONP        1525
#define PORT_DATAMETRICSRADIUS 1645
#define PORT_SAMSG             1646
#define PORT_RADIUS            1812
#define PORT_RADACCOUNT        1813
#define PORT_CVSSERVER         2401
#define PORT_VENUS             2430
#define PORT_VENUSSE           2431
#define PORT_CODASERVER        2432
#define PORT_CODASERVERSE      2433
#define PORT_MYSQL             3306
#define PORT_RFE               5002
#define PORT_SIP               5060
#define PORT_CFENGINE          5308
#define PORT_BBS               7000 


typedef void (*app_func_t)(packet_t *);

void init_ip_protocols(void);
app_func_t port2func(u_int16_t);

#endif





