/**************************************************************************** 
** File: packet_manip.h
**
** Author: Mike Borella
**
** Comments: Header file for packet structures and manipulation functions
**
*****************************************************************************/

#ifndef PACKET_MANIP_H
#define PACKET_MANIP_H

#include <sys/types.h>

/*
 * Data structure that contains the bytestring of a packet and pointers 
 * to the next byte to read as well as the end.
 */

typedef struct packet
{
  u_int8_t * contents;
  u_int8_t * current;
  u_int8_t * end;
  u_int32_t  media_length; /* length of the packet as reported by the media */
  char       timestamp [32];
} packet_t;


inline int look_packet_bytes(u_int8_t *, packet_t *, unsigned int);
inline int get_packet_bytes(u_int8_t *, packet_t *, unsigned int);
inline int get_packet_line(u_int8_t *, u_int32_t, packet_t *);
inline int skip_packet_bytes(packet_t *, unsigned int);
u_int32_t get_packet_bytesleft(packet_t *);

#endif
