/**************************************************************************** 
** File: rip.c
**
** Author: Mike Borella
**
** Comments: Dump RIP header information. 
**
*****************************************************************************/

#include <string.h>
#include "global.h"
#include "protocols.h"

/*----------------------------------------------------------------------------
**
** dump_rip()
**
** Parse RIP packet and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_rip(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  RipHdr *rip;
  RipRouteHdr *rip_route;
  RipAuthHdr *rip_auth;
  int route_cnt;

  p = bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        RIP Header\n");
  printf("-----------------------------------------------------------------\n");

  rip = (RipHdr *) p;

  printf("Command:                %d ", (int) rip->command);
  switch(rip->command)
    {
    case RIP_CMD_RQ:
      printf("(request)\n");
      break;
    case RIP_CMD_RP:
      printf("(reply)\n");
      break;
    case RIP_CMD_POLL:
      printf("(poll)\n");
      break;
    case RIP_CMD_POLL_ENTRY:
      printf("(poll entry)\n");
      break;
    default:
      printf("(unknown)\n");
    }
  printf("Version:                %d\n", (int) rip->version);
  printf("Routing domain:         %d\n", (int) rip->domain);

  p = p + sizeof(RipHdr);

  /*
   * Do the individual routes
   */

  route_cnt = 0;
  while (p < ep)
    {
      route_cnt++;
      printf("Route:                  %d\n", route_cnt);
 
      rip_route = (RipRouteHdr *) p;

      if (rip_route->addr_fam == 0xffff)
	{
	  rip_auth = (RipAuthHdr *) p;

	  p = p + sizeof(RipAuthHdr);
	}
      else
	{
	  printf("  Address family:       %d\n", 
		 (int) ntohs(rip_route->addr_fam));
	  printf("  Route tag:            %d\n", 
		 (int) ntohs(rip_route->route_tag));
	  /* rip_route->ipaddr.s_addr = ntohl(rip_route->ipaddr.s_addr); */
	  printf("  IP address            %s\n", 
		 inet_ntoa(rip_route->ipaddr));
	  /* rip_route->netmask.s_addr = ntohl(rip_route->netmask.s_addr); */
	  printf("  Netmask:              %s\n", 
		 inet_ntoa(rip_route->netmask));
	  /* rip_route->next_hop.s_addr = ntohl(rip_route->next_hop.s_addr); */
	  printf("  Next hop:             %s\n", 
		 inet_ntoa(rip_route->next_hop));
	  printf("  Metric:               %d\n", 
		 (int) ntohl(rip_route->metric));
	  p = p + sizeof(RipRouteHdr);
	}
    } /* while */
}
