
AC_DEFUN(AC_PCAP,
[
	dnl look for libpcap
	AC_CHECK_LIB(pcap, main,,AC_MSG_ERROR(libpcap not found))

	dnl places where pcap.h might be
	pcap_places=". pcap"

	for dir in $pcap_places; do
		AC_CHECK_HEADER($dir/pcap.h, pcap_h_dir=$dir)
		if test -r /usr/include/$pcap_h_dir/pcap.h; then
			break;
		fi
	done

	if test -r /usr/include/$pcap_h_dir/pcap.h; then
		CPPFLAGS="$CPPFLAGS -I/usr/include/$pcap_h_dir"
		AC_SUBST(CPPFLAGS)
	else
		AC_MSG_ERROR(Header file pcap.h not found.)
	fi
]
)

AC_DEFUN(AC_UCDSNMP,
[
	dnl look for UCD SNMP
	AC_CHECK_LIB(snmp, asn_parse_int)

	dnl places where asn1.h might be
	snmp_places=". ucd-snmp"

	for dir in $snmp_places; do
		AC_CHECK_HEADER($dir/asn1.h, snmp_dir=$dir)
		if test -r /usr/include/$snmp_dir/asn1.h; then
			break;
		fi
	done

	if test -r /usr/include/$snmp_dir/asn1.h; then
		CPPFLAGS="$CPPFLAGS -I/usr/include/$snmp_dir"
		AC_SUBST(CPPFLAGS)
		AC_DEFINE(HAVE_ASN1_H)
	fi
]
)

