/**************************************************************************** 
** File: ah.h
**
** Author: Mike Borella
**
** Comments: Structure of AH packets
**
** $Log: ah.h,v $
** Revision 1.2  2000/05/08 23:36:04  mborella
** Got rid of addrtoname.c module.  Functionality is now taken care of in our
** own way.
**
*****************************************************************************/

#ifndef AH_H
#define AH_H

/*
 * Static part of AH header
 */

typedef struct ah_header
{
#if defined(WORDS_BIGENDIAN)
  u_int32_t reserved:16,
            length:8,
            next:8;
#else
  u_int32_t next:8,
            length:8,
            reserved:16;
#endif
  u_int32_t spi;
  u_int32_t seqno;
  
} ah_header_t;

void dump_ah(packet_t *);

#endif
