/**************************************************************************** 
** File: global.h
**
** Author: Mike Borella
**
** Comments: Includes the header files that most or all modules will need.
**
*****************************************************************************/

#ifndef GLOBAL_H
#define GLOBAL_H

#include <sys/types.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "display.h"
#include "packet_manip.h"
#include "strmap.h"
#include "parse_cl.h"

#define EXTRACT_16BITS(p) ((u_int16_t) ntohs (*(u_int16_t *)(p)))
#define EXTRACT_32BITS(p) ((u_int32_t) ntohl (*(u_int32_t *)(p)))

/*
 * This is a stupid hack to get around forcing signal handlers to take
 * an int as an argument
 */

typedef void (*sighandler_t)(int);


#endif
