/**************************************************************************** 
** File: http.c
**
** Author: Mike Borella
**
** Comments: Dump HTTP header information. I didn't try to do anything
** fancy with this - I just dump the plaintext headers.  This makes 
** debugging easier since parsing is such a pain to get right.
**
*****************************************************************************/

#include "global.h"
#include "protocols.h"

#define LINE_SIZE 256
#define FALSE 0
#define TRUE  1

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_http()
**
** Parse HTTP packet and dump fields. 
**
**----------------------------------------------------------------------------
*/

void dump_http(packet_t *pkt)
{
  char line[LINE_SIZE];
  int i;
  int n = 0;
  int len;
  int seen_nonws;
  int first_line = 1;

#ifdef DEBUG
  printf("\nEntering HTTP\n");
#endif

  /* announcement */
  if (!my_args->m)
    display_header_banner("HTTP");
  
  while(1)
    {
      len = get_packet_line(line, LINE_SIZE, pkt);
      if (len == 0)
	break;
      
      /*
       * If the first line doesn't 
       * contain 'HTTP/', assume that there are no headers.
       * In minimal mode, just dump the first line.
       */

      if (first_line)
	{
	  if (!strstr(line, "HTTP/"))
	    break;
	  if (my_args->m)
	    {
	      display_minimal_string(line);
	      break;
	    }
	}
      first_line = 0;

      /*
       * If we have a line of all whitespace, that's the end of the headers.
       */

      seen_nonws = 0;
      for (i=0; i<strlen(line); i++)
	{
	  if (!isspace(line[i]))
	    {
	      seen_nonws = 1;
	      break;
	    }
	}
      if (seen_nonws == 0)
	break;
	  
      /*
       * Display a header
       */

      display("Header", (u_int8_t *) line, strlen(line), DISP_STRING);

      /*
       * Convert each line to lower case for easier parsing.
       */

      for (i=0; i<strlen(line); i++)
	line[i] = tolower(line[i]);
    }

#ifdef DEBUG
  printf("\nLeaving HTTP\n");
#endif

}
