/**************************************************************************** 
** File: icmpv6.c
**
** Author: Mike Borella
**
** Comments: Dump ICMPv6 information
**
** $Log: icmpv6.c,v $
** Revision 1.2  2000/06/01 18:36:55  mborella
** Made sure that all string maps are properly terminated, added TODO
** file, minor improvments to ICMPv6.
**
** Revision 1.1  2000/05/31 00:07:09  mborella
** Added very basic framework for ICMPv6 support.  Nothing useful yet.
**
*****************************************************************************/

#include "global.h"
#include "protocols.h"

strmap_t icmpv6_type_map [] =
{
  { ICMPV6_TYPE_DESTUNREACHABLE,    "destination unreachable" },
  { ICMPV6_TYPE_PACKETTOOBIG,       "packet too big" },
  { ICMPV6_TYPE_TIMEEXCEEDED,       "time exceeded" },
  { ICMPV6_TYPE_PARAMETERPROBLEM,   "parameter problem" },
  { ICMPV6_TYPE_ECHOREQUEST,        "echo request" },
  { ICMPV6_TYPE_ECHOREPLY,          "echo reply" },
  { ICMPV6_TYPE_GROUPMEMQUERY,      "group membership query" },
  { ICMPV6_TYPE_GROUPMEMREPORT,     "group membership report" },
  { ICMPV6_TYPE_GROUPMEMREDUCTION,  "group membership reduction" },
  { ICMPV6_TYPE_ROUTERSOLICIT,      "router solicitation" },
  { ICMPV6_TYPE_ROUTERADVERT,       "router advertisement" },
  { ICMPV6_TYPE_NEIGHBORSOLICIT,    "neighbor solicitation" },
  { ICMPV6_TYPE_NEIGHBORADVERT,     "neighbor advertisement" },
  { ICMPV6_TYPE_REDIRECT,           "redirect" },
  { 0, "" }
};

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_icmpv6()
**
** Parse ICMPv6 header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_icmpv6(packet_t *pkt)
{
  icmpv6_header_t icmpv6;
  char            holder[64];

  /*
   * Get the ICMPv6 header
   */

  if (get_packet_bytes((u_int8_t *) &icmpv6, pkt, 4) == 0)
    return;

  /*
   * Conversions
   */

  icmpv6.checksum = ntohs(icmpv6.checksum);

  /*
   * Dump header
   */

  if (my_args->m)
    {
      display_minimal_string("ICMPv6 ");
      display_minimal_string(map2str(icmpv6_type_map, icmpv6.type));
      display_minimal_string(" ");
    }
  else
    if (!my_args->n)
      {
	/* announcement */
	display_header_banner("ICMPv6 Header");
	
	/* print fields */
	sprintf(holder, "%d (%s)", icmpv6.type, 
		map2str(icmpv6_type_map, icmpv6.type));

	display("Checksum", (u_int8_t *) &icmpv6.checksum, 2, DISP_2BYTEDEC);
	display("Checksum", (u_int8_t *) &icmpv6.checksum, 2, DISP_2BYTEDEC);
      }

}




