/**************************************************************************** 
** File: icmpv6.h
**
** Author: Mike Borella
**
** Comments: Generic ICMPv6 header structures.
**
** $Log: icmpv6.h,v $
** Revision 1.3  2000/06/01 19:12:35  mborella
** Added minimal mode to SPX (not complete), added a little more support
** for ICMPv6 (also not complete)
**
** Revision 1.2  2000/06/01 18:36:55  mborella
** Made sure that all string maps are properly terminated, added TODO
** file, minor improvments to ICMPv6.
**
** Revision 1.1  2000/05/31 00:07:09  mborella
** Added very basic framework for ICMPv6 support.  Nothing useful yet.
**
*****************************************************************************/

#ifndef ICMPV6_H
#define ICMPV6_H

/*
 * ICMPv6 type fields
 */

#define ICMPV6_TYPE_DESTUNREACHABLE     1
#define ICMPV6_TYPE_PACKETTOOBIG        2
#define ICMPV6_TYPE_TIMEEXCEEDED        3
#define ICMPV6_TYPE_PARAMETERPROBLEM    4
#define ICMPV6_TYPE_ECHOREQUEST         128
#define ICMPV6_TYPE_ECHOREPLY           129
#define ICMPV6_TYPE_GROUPMEMQUERY       130
#define ICMPV6_TYPE_GROUPMEMREPORT      131
#define ICMPV6_TYPE_GROUPMEMREDUCTION   132
#define ICMPV6_TYPE_ROUTERSOLICIT       133
#define ICMPV6_TYPE_ROUTERADVERT        134
#define ICMPV6_TYPE_NEIGHBORSOLICIT     135
#define ICMPV6_TYPE_NEIGHBORADVERT      136
#define ICMPV6_TYPE_REDIRECT            137

/*
 * ICMPv6 destination unreachable code fields
 */

#define ICMPV6_DU_CODE_NOROUTE          0
#define ICMPV6_DU_CODE_ADMIN            1
#define ICMPV6_DU_CODE_ADDRUNREACHABLE  2
#define ICMPV6_DU_CODE_PORTUNREACHABLE  3

/*
 * ICMPv6 time exceeded code fields
 */

#define ICMPV6_TE_CODE_HOPLIMIT         0
#define ICMPV6_TE_CODE_REASSEMBLY       1

/*
 * ICMPv6 parameter problem code fields
 */

#define ICMPV6_PP_CODE_BADHEADERFIELD   0
#define ICMPV6_PP_CODE_BADNEXTHEADER    1
#define ICMPV6_PP_CODE_BADIPV6OPTION    2

#include "global.h"

typedef struct icmpv6_header
{
  u_int8_t       type;
  u_int8_t       code;
  u_int16_t      checksum;
} icmpv6_header_t;

void dump_icmpv6(packet_t *);

#endif
