/**************************************************************************** 
** File: igmp.h
**
** Author: Mike Borella
**
** Comments: Generic IGMP header format
**
** $Log: igmp.h,v $
** Revision 1.1  2000/05/11 21:33:02  mborella
** Lots of changes.  Added IGMP support.  Fixed IP options.  Added some
** more port mappings.
**
*****************************************************************************/


typedef struct igmp_header
{
  u_int8_t type;
  u_int8_t max_resp_time;
  u_int16_t checksum;
  u_int32_t address;
} igmp_header_t;

/*
 * IGMP types
 */

#define IGMP_TYPE_MEMBERQUERY      0x11
#define IGMP_TYPE_MEMBERREPORTV1   0x12
#define IGMP_TYPE_DVMRP            0x13
#define IGMP_TYPE_MEMBERREPORTV2   0x16
#define IGMP_TYPE_LEAVEGROUP       0x17

void dump_igmp(packet_t *);
