/**************************************************************************** 
** File: ipv6.h
**
** Author: Mike Borella
**
** Comments: Generic IPv6 header structure.
**
** $Log: ipv6.h,v $
** Revision 1.5  2000/05/31 00:07:09  mborella
** Added very basic framework for ICMPv6 support.  Nothing useful yet.
**
** Revision 1.4  2000/05/12 22:02:53  mborella
** Fixed naasty IPv6 byteorder problems.
**
** Revision 1.3  2000/05/12 21:56:49  mborella
** Got rid of more build and dependency problems...
**
** Revision 1.2  2000/05/11 21:52:49  mborella
** Trying to figure out what's wrong with these files - each of them
** always claims to be modified...
**
*****************************************************************************/

#ifndef IPV6_H
#define IPV6_H

#include "global.h"

typedef struct ipv6_header
{
#if defined(WORDS_BIGENDIAN)
  u_int8_t       version:4, 
                 traffic_class_high:4;
  u_int8_t       traffic_class_low:4,
                 flow_label_high:4;
#else
  u_int8_t       traffic_class_high:4,
                 version:4;
  u_int8_t       flow_label_high:4,
                 traffic_class_low:4;
#endif
  u_int16_t      flow_label_low;
  u_int16_t      payload_length;
  u_int8_t       next_header;
  u_int8_t       hop_limit;
  u_int8_t       src_addr[16];
  u_int8_t       dst_addr[16];
} ipv6_header_t;

void dump_ipv6(packet_t *);

#endif
