/**************************************************************************** 
** File: ipx.h
**
** Author: Mike Borella
**
** Comments: IPX header format and such
**
** $Log: ipx.h,v $
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.4  2000/05/04 00:25:10  mborella
** Updated IPX for new API.  IPX RIP and SPX are now slightly broken.
** You've been warned...
**
** Revision 1.3  2000/04/16 23:28:46  mborella
** This is a major update, maoving the base IP stack protocols to the new
** generic reading and writing system.  Some stuff is still broken.
**
** Revision 1.2  2000/04/13 20:19:53  mborella
** Added more generic display features, cleaned up more cruft.
**
** Revision 1.1.1.1  2000/04/11 17:26:16  mborella
** Initial checkin of release 0.8.2 code.
**
*****************************************************************************/

#ifndef IPX_H
#define IPX_H

/*
 * IPX packet types
 */

#define IPX_PACKETTYPE_UNKNOWN     0
#define IPX_PACKETTYPE_RIP         1
#define IPX_PACKETTYPE_ECHO        2
#define IPX_PACKETTYPE_ERROR       3
#define IPX_PACKETTYPE_PEP         4
#define IPX_PACKETTYPE_SPX         5
#define IPX_PACKETTYPE_NCP         17
#define IPX_PACKETTYPE_NETBIOS     20

/*
 * IPX header 
 */

typedef struct ipx_header
{
  u_int16_t csum;
  u_int16_t len;
  u_int8_t  tc;
  u_int8_t  pt;
  u_int32_t dstnet;
  u_char    dstnode[6];
  u_int16_t dstport;
  u_int32_t srcnet;
  u_char    srcnode[6];
  u_int16_t srcport;
} ipx_header_t;

void dump_ipx(packet_t *);

#endif



