/**************************************************************************** 
** File: ipxrip.h
**
** Author: Mike Borella
**
** Comments: IPX/RIP header format and such
**
** $Log: ipxrip.h,v $
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.3  2000/05/04 18:49:11  mborella
** Fixed IPX RIP.
**
** Revision 1.2  2000/05/04 00:25:10  mborella
** Updated IPX for new API.  IPX RIP and SPX are now slightly broken.
** You've been warned...
**
** Revision 1.1.1.1  2000/04/11 17:26:17  mborella
** Initial checkin of release 0.8.2 code.
**
** Revision 1.2  1998/06/12 20:48:33  mborella
** Added log tag
**
*****************************************************************************/

#ifndef IPXRIP_H
#define IPXRIP_H

/*
 * IPX RIP commands 
 */

#define IPXRIP_COMMAND_REQUEST    1
#define IPXRIP_COMMAND_RESPONSE   2

/*
 * Routing entries
 */

typedef struct ipxrip_entry
{
  u_int32_t net;
  u_int16_t hops;
  u_int16_t ticks;
} ipxrip_entry_t;

/*
 * Generic header
 */

typedef struct ipxrip_header
{
  u_int16_t op;
} ipxrip_header_t;

void dump_ipxrip(packet_t *);

#endif
