/**************************************************************************** 
** File: ospf.h
**
** Author: Mike Borella
**
** Comments: OSPF common header format
**
** $Log: ospf.h,v $
** Revision 1.2  2000/05/21 16:20:11  mborella
** Tentative OSPF support.  Completely untested.
**
** Revision 1.1  2000/05/21 15:26:41  mborella
** Added OSPF shim.  Doesn't actually work yet.  Also added autoconf hack
** that will look in several places for pcap.h.  Finally, added a few new
** IP protocols.
**
*****************************************************************************/

#ifndef OSPF_H
#define OSPF_H

/*
 * Format of OSPF common header 
 */

typedef struct ospf_common_header
{
  u_int8_t  version;
  u_int8_t  type;
  u_int16_t length;
  u_int32_t router_id;
  u_int32_t area_id;
  u_int16_t checksum;
  u_int16_t auth_type;
  u_int8_t  auth_data[8];
} ospf_common_header_t;

/*
 * OSPF types
 */

#define OSPF_TYPE_HELLO        1
#define OSPF_TYPE_DATABASEDESC 2
#define OSPF_TYPE_LSREQUEST    3
#define OSPF_TYPE_LSUPDATE     4
#define OSPF_TYPE_LSACK        5

/*
 * OSPF Authentication types
 */

#define OSPF_AUTH_NONE         0
#define OSPF_AUTH_SIMPLE       1
#define OSPF_AUTH_CRYPTO       2

void dump_ospf(packet_t *);

#endif
