/**************************************************************************** 
**
** File: raw.c
**
** Author: Mike Borella
**
** Comments: Dump raw data link (IP) packets
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <pcap.h>
#include "global.h"
#include "protocols.h"

/*----------------------------------------------------------------------------
**
** dump_raw()
**
** Process packets from the DLT_RAW interface type
**
**----------------------------------------------------------------------------
*/

void dump_raw(packet_t *pkt)
{
  char ann_str[64];

  /*
   * Dump header announcement
   */

  sprintf(ann_str, "%s (%s)", "Raw header", pkt->timestamp);
  display_header_banner(ann_str);

  dump_ip(pkt);
}
