/**************************************************************************** 
** File: display.h
**
** Author: Mike Borella
**
** Comments: Header file for displaying functions
** 
** $Log: display.h,v $
** Revision 1.8  2000/06/19 16:41:25  mborella
** Made a new API display type: DISP_DEC, which replaces all decimal type
** displaying functions.  Required overcoming the usual hairy byte ordering
** issues, and I'm hoping it isn't going to screw anything up.
**
** Revision 1.7  2000/06/16 23:03:21  mborella
** Added special printing functions for ipv4 and ipv6 addresses.
**
** Revision 1.6  2000/05/10 18:26:50  mborella
** Added TCP option support, cleaned up minimal mode, added TCP window
** advert to minimal mode, added timestamp to all lines in minimal mode.
**
** Revision 1.5  2000/05/09 19:41:01  mborella
** Fixed minimal mode for ICMP, fixed IPv6 header printing, added the minimal
** string display mode.
**
** Revision 1.4  2000/05/08 23:36:04  mborella
** Got rid of addrtoname.c module.  Functionality is now taken care of in our
** own way.
**
** Revision 1.3  2000/05/08 22:55:45  mborella
** Basic support for IPv6.
**
** Revision 1.2  2000/05/08 21:18:23  mborella
** Made "minimal mode" into a one-line tcpdump-like mode.
**
** Revision 1.1  2000/05/04 19:21:55  mborella
** Adding more files to src.
**
** Revision 1.8  2000/04/28 23:43:46  mborella
** Fixed hex printing style.  Began implementing port to string map.
**
** Revision 1.7  2000/04/17 23:20:00  mborella
** Minor fixes to Ethernet, rudimentary support for IP options.
**
*****************************************************************************/

#ifndef DISPLAY_H
#define DISPLAY_H

#include <sys/types.h>

/*
 * Display format types
 */

typedef enum display
{
  DISP_1BYTEDEC,     /* 1 byte, decimal format (12) */
  DISP_2BYTEDEC,     /* 2 bytes, decimal format (10, 5) */
  DISP_4BYTEDEC,     /* 4 bytes, decimal format (10, 5, 234234) */
  DISP_DEC,          /* Display and arbitrary decimal value */
  DISP_BIN,          /* Binary format with leading 0's (01101110) */
  DISP_BINNLZ,       /* Binary format w/o leading 0's (1101110) */
  DISP_HEX,          /* 2 bytes, hex (0F) */
  DISP_HEXCOLONS,    /* Hex bytes separated by colons (0F:7A:B1) */
  DISP_HEXCOLONS4,   /* 4 Hex bytes between colons */
  DISP_DOTTEDDEC,    /* Dotted decimal (IP address) format (4 bytes only) */
  DISP_STRING        /* Plain old ascii string */
} display_t;

/*
 * Function prototypes
 */

inline void display_header_line (void);
inline void display_header_line2 (void);
inline void display_header_banner (char *);
inline void display (char *, u_int8_t *, u_int8_t, display_t);
inline void display_string (u_int8_t *, u_int8_t *);
inline void display_ipv4 (u_int8_t *, u_int8_t *);
inline void display_ipv6 (u_int8_t *, u_int8_t *);
inline void display_minimal (u_int8_t * content, u_int8_t length, 
			    display_t format);
inline void display_minimal_string (u_int8_t *);
inline void display_minimal_ipv4 (u_int8_t *);
inline void display_minimal_ipv6 (u_int8_t *);

#endif
