/**************************************************************************** 
** File: dns_labels.h
**
** Author: Mike Borella
**
** Comments: Encapsulation for ugly DNS label manipulation
**
** $Log: dns_labels.h,v $
** Revision 1.1  2000/05/21 19:39:02  mborella
** Added API for DNS label manipulation.  What a mess.  Added to the
** packet manip API as well, so that a place in a packet can be "marked"
** and the distance from that mark can be computed.
**
*****************************************************************************/

#include "global.h"

/*
 * This is a DNS label.  We save all labels so that we can refer to them
 * without re-reading the packet.  This is SO annoying!
 */

typedef struct dns_label
{
  int32_t offset;       /* offset from beginning of DNS payload */
  char label[32];       /* char string contents of label */
  int next;             /* next label */
} dns_label_t;

void reset_dnslabels(void);
void new_dnslabel(void);
void set_dnslabel_offset(int32_t);
void set_dnslabel_label(char *);
void set_dnslabel_next(void);
void get_dnslabel(int32_t, char *);   /* get a DNS label given its offset */
