/**************************************************************************** 
** File: ripng.c
**
** Author: Mike Borella
**
** Comments: Dump RIPng header information. 
**
** $Log$
*****************************************************************************/

#include <string.h>
#include "global.h"
#include "protocols.h"

/*
 * RIPng command map
 */

strmap_t ripng_command_map [] =
{
  { RIP_CMD_RQ,          "request" },
  { RIP_CMD_RP,          "reply" },
  { 0, "" }
};

extern struct arg_t * my_args;

/*----------------------------------------------------------------------------
**
** dump_ripng()
**
** Parse RIPng packet and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_ripng(packet_t *pkt)
{
  ripng_header_t       ripng;
  ripng_route_header_t ripng_route;
  int                  route_cnt;
  char                 holder[64];
  u_int16_t            address_family;

  /*
   * Get the RIP v2 static header
   */
      
  if (get_packet_bytes((u_int8_t *) &ripng, pkt, sizeof(ripng_header_t)) == 0)
    return;

  /*
   * Dump header
   */
      
  if (my_args->m)
    {
      display_minimal_string("RIPng ");
      display_minimal_string(map2str(ripng_command_map, ripng.command));
      display_minimal_string(" ");
    }
      else
    {
      /* announcement */
      display_header_banner("RIPng Header");
      
      sprintf(holder, "%d (%s)", ripng.command, 
              map2str(ripng_command_map, ripng.command));
      display_string("Command", holder);
      display("Version", (u_int8_t *) &ripng.version, 1, DISP_1BYTEDEC);
      display("MBZ", (u_int8_t *) &ripng.mbz, 2, DISP_2BYTEDEC);
    }
      
  /*
   * Do the individual routes.
   */
  
  while (1)
    {
      if (get_packet_bytes((u_int8_t *) &ripng_route, pkt, 
			   sizeof(ripng_route_header_t)) == 0)
	return;
	      
      /*
       * Conversions
       */
      
      ripng_route.route_tag = ntohs(ripng_route.route_tag);

      /*
       * Dump route header
       */
      
      if (my_args->m)
	{
	  display_minimal_ipv6((u_int8_t *) &ripng_route.address);
	  display_minimal_string(" ");
	}
      else
	{
	  display_ipv6("Address", (u_int8_t *) &ripng_route.address);
	  display("Route tag", (u_int8_t *) &ripng_route.route_tag, 2, 
		  DISP_2BYTEDEC);
	  display("Netmask", (u_int8_t *) &ripng_route.netmask, 1, 
		  DISP_1BYTEDEC);
	  display("Metric", (u_int8_t *) &ripng_route.metric, 1, 
		  DISP_1BYTEDEC);
	}
      
    } /* while */
}

