/**************************************************************************** 
** File: arp.h
**
** Author: Mike Borella
**
** Comments: Generic ARP structure - an attempt at OS independence
**
** $Log: arp.h,v $
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.5  2000/04/18 18:32:12  mborella
** Fixed Ethernet timestamp.
** ARP now uses IANA string mechanism.
**
** Revision 1.4  2000/04/17 20:54:01  mborella
** Fixed ARP and cleaned it up.
**
** Revision 1.3  2000/04/16 23:28:46  mborella
** This is a major update, maoving the base IP stack protocols to the new
** generic reading and writing system.  Some stuff is still broken.
**
** Revision 1.2  2000/04/13 18:39:03  mborella
** Began to switch to generic display mechanism.  Removing cruft as well.
**
** Revision 1.1.1.1  2000/04/11 17:26:16  mborella
** Initial checkin of release 0.8.2 code.
**
*****************************************************************************/

#ifndef ARP_H
#define ARP_H

/*
 * ARP hardware identifiers (not even close to complete...)
 */

#define ARP_HWTYPE_ETHERNET  1
#define ARP_HWTYPE_IEEE802   6
#define ARP_HWTYPE_IEEE1394  29

/* 
 * ARP protocol opcodes. 
 */

#define ARP_OPCODE_REQUEST   1            /* ARP request                  */
#define ARP_OPCODE_REPLY     2            /* ARP reply                    */
#define RARP_OPCODE_REQUEST  3            /* RARP request                 */
#define RARP_OPCODE_REPLY    4            /* RARP reply                   */

/*
 * ARP header
 */

typedef struct arp_header
{
  u_int16_t hwaddr_format;             /* format of hardware address   */
  u_int16_t protoaddr_format;          /* format of protocol address   */
  u_int8_t  hwaddr_length;             /* length of hardware address   */
  u_int8_t  protoaddr_length;          /* length of protocol address   */
  u_int16_t opcode;                    /* ARP opcode (command)         */
} arp_header_t;

/*
 * Ethernet ARP format
 */
    
typedef struct ether_arp
{
  u_int8_t sender_hwaddr[6];        /* sender hardware address */
  u_int8_t sender_protoaddr[4];     /* sender protocol address */
  u_int8_t target_hwaddr[6];        /* target hardware address */
  u_int8_t target_protoaddr[4];     /* target protocol address */
} ether_arp_t;


void dump_arp(packet_t *);

#endif
