/**************************************************************************** 
** File: dns_labels.c
**
** Author: Mike Borella
**
** Comments: Encapsulation for ugly DNS label manipulation
**
** $Log: dns_labels.c,v $
** Revision 1.1  2000/05/21 19:39:02  mborella
** Added API for DNS label manipulation.  What a mess.  Added to the
** packet manip API as well, so that a place in a packet can be "marked"
** and the distance from that mark can be computed.
**
*****************************************************************************/

#include <string.h>
#include "dns_labels.h"

#define NUM_LABELS 128

int current_label = -1;
dns_label_t dnslabels[NUM_LABELS];


/*----------------------------------------------------------------------------
**
** reset_dnslabels()
**
** Initialize the DNS labels structures
**
**----------------------------------------------------------------------------
*/

void reset_dnslabels(void)
{
  int i;

  current_label = -1;
  for (i=0; i<NUM_LABELS; i++)
    {
      dnslabels[i].offset = 0; 
      dnslabels[i].label[0] = '\0';
      dnslabels[i].next = -1; 
    }
}
/*----------------------------------------------------------------------------
**
** new_dnslabel()
**
** A define a new DNS label
**
**----------------------------------------------------------------------------
*/

void new_dnslabel(void)
{
  current_label++;
  dnslabels[current_label].offset = 0; 
  dnslabels[current_label].label[0] = '\0';
  dnslabels[current_label].next = -1; 
}

/*----------------------------------------------------------------------------
**
** set_dnslabel_offset()
**
** Set the offset of a DNS label
**
**----------------------------------------------------------------------------
*/

void set_dnslabel_offset(int32_t o)
{
  dnslabels[current_label].offset = o; 
}

/*----------------------------------------------------------------------------
**
** set_dnslabel_label()
**
** Set a DNS label
**
**----------------------------------------------------------------------------
*/

void set_dnslabel_label(char *s)
{
  strcpy(dnslabels[current_label].label, s);
}

/*----------------------------------------------------------------------------
**
** set_dnslabel_next()
**
** Set the next label
**
**----------------------------------------------------------------------------
*/

void set_dnslabel_next(void)
{
  dnslabels[current_label].next = current_label+1; 
}

/*----------------------------------------------------------------------------
**
** get_dnslabel()
**
** Get a DNS label and follow the chain of next pointers
**
**----------------------------------------------------------------------------
*/

void get_dnslabel(int32_t o, char *s)
{
  int i;

  strcpy(s,"\0");
  for (i=0; i<=current_label; i++)
    if (dnslabels[i].offset == o)
      {
	strcpy(s, dnslabels[i].label);
	if (dnslabels[i].next >= 0)
	  {
	    strcat(s, ".");
	    get_dnslabel(dnslabels[dnslabels[i].next].offset, 
			 s+strlen(s));
	  }
	strcat(s, "\0");
	break;
      }
}


