/**************************************************************************** 
**
** File: gwf_error.h
**
** Author: Mike Borella
**
** Comments: Definitions for gwf_error.c.  The goal here is to have a clean
**           API for useful error reporting.  We three different types of
**           errors: messages fatal, and system.  
**
**           System errors result from failed system calls, and errno info
**           is reported.  The program is aborted
**
**           Fatal errors are any other error which requires program 
**           termination.
**
**           Message errors are like fatal errors, but just print a message
**           without aborting.
**
**           There are two types of each error, regular and debug.  Regular
**           errors allow us to pass a printf-like variable list to 
**           display.  Debug errors display the file name and line
**           number of the caller, but do not allow a variable number
**           of arguments.  
**
**           TODO: Combine these two types of errors for a cleaner API?
**                 I don't know if that is possible due to the lack of support
**                 for variable-length arguments in macros. Hmmm.
**
*****************************************************************************/

#include <stdarg.h>
#include <string.h>

void GWF_error(int, char *, int, const char *fmt, va_list);
void GWF_error_system(char *fmt, ...);
void GWF_error_fatal(char *fmt, ...);
void GWF_error_message(char *fmt, ...);

/*
#define GWF_error_systemd(X)  GWF_error(1,__FILE__,__LINE__,strcat(X,"\%s"),"")
#define GWF_error_fatald(X)   GWF_error(0,__FILE__,__LINE__,X,"")
#define GWF_error_messaged(X) GWF_error(0,__FILE__,__LINE__,X,"")
*/

