/**************************************************************************** 
** File: esp.c
**
** Author: Mike Borella
**
** Comments: Dump ESP header information. Since this packet sniffer
** is stateless, we cannot determine any headers besides the SPI and the
** sequence number.  In order to figure out the padding length and next 
** payload headers we would need to know the authentication mechanism 
** (if any) used for this SA.  But that info is part of the ISAKMP
** negotiation rather than the ESP header.  Oh well.
**
*****************************************************************************/

#include "global.h"
#include "protocols.h"

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_esp()
**
** Parse ESP packet and dump fields.
**
**----------------------------------------------------------------------------
*/

void dump_esp(packet_t *pkt)
{
  esp_header_t esp;

  /*
   * Get the ESP header
   */

  if (get_packet_bytes((u_int8_t *) &esp, pkt, sizeof(esp_header_t)) == 0)
    return;

  /*
   * Conversions
   */

  esp.spi = ntohl(esp.spi);
  esp.spi = ntohl(esp.seqno);

  /*
   * Dump header
   */

  if (my_args->m && !my_args->n)
    {
      display_minimal((u_int8_t *) &esp.spi, 4, DISP_HEX); 
      display_minimal_string(" ");
    }
  else
    if (!my_args->n)
      {
        /* announcement */
        display_header_banner("ESP Header");
	display("SPI", (u_int8_t *) &esp.spi, 4, DISP_HEX); 
        display("Sequence number", (u_int8_t *) &esp.seqno, 4, DISP_DEC);
      }

}

