/**************************************************************************** 
** File: igmp.c
**
** Author: Mike Borella
**
** Comments: Dump IGMP information
**
** $Log: igmp.c,v $
** Revision 1.4  2000/06/19 15:32:12  mborella
** Modified all files to use new address display API (not that it makes
** a bit of difference to the user...) Also tested RIPng and it seems
** to work ok.
**
** Revision 1.3  2000/06/16 22:28:17  mborella
** Added preliminary RIPng support that probably doesn't work, prettied
** up ARP and IGMP, fixed SNMP so that it compiles on Freebsd.
**
** Revision 1.2  2000/06/01 18:36:55  mborella
** Made sure that all string maps are properly terminated, added TODO
** file, minor improvments to ICMPv6.
**
*****************************************************************************/

#include "global.h"
#include "protocols.h"

extern struct arg_t * my_args;

/* 
 * Contains the descriptions of IGMP types 
 */

strmap_t igmp_type_map[] = 
{
  { IGMP_TYPE_MEMBERQUERY,     "membership query" },
  { IGMP_TYPE_MEMBERREPORTV1,  "v1 membership report" },
  { IGMP_TYPE_DVMRP,           "DVMRP" },
  { IGMP_TYPE_MEMBERREPORTV2,  "v2 membership report" },
  { IGMP_TYPE_LEAVEGROUP,      "leave group" },
  { 0, "" }
};

/*----------------------------------------------------------------------------
**
** dump_igmp()
**
** Parse IGMP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_igmp(packet_t *pkt)
{
  igmp_header_t igmp;
  char holder[64];

  /*
   * Get the header. Note that the length of 8 may cause a problem with 
   * some DVMRP packets, but so far it hasn't.  Change it to 4 later for 
   * safety... -MB
   */

  if (get_packet_bytes((u_int8_t *) &igmp, pkt, 8) == 0)
    return;

  /*
   * Conversions
   */

  igmp.checksum = ntohs(igmp.checksum);

  /*
   * Dump the contents
   */

  if (my_args->m && !my_args->n)
    {
      /* In minimal mode lets just dump the type and address */
      display_minimal_string("IGMP ");
      display_minimal_string(map2str(igmp_type_map, igmp.type));
      display_minimal_string(" ");
    }
  else
    if (!my_args->n)
      { 
	/* announcement */
	display_header_banner("IGMP Header");
	
	/* Dump the type, max resp time, checksum and address */
	sprintf(holder, "%d (%s)", igmp.type, 
		map2str(igmp_type_map, igmp.type));
	display_string("Type", holder);
	display("Max response time", (u_int8_t *) &igmp.max_resp_time, 1,
		DISP_1BYTEDEC);
	display("Checksum", (u_int8_t *) &igmp.checksum, 2, DISP_2BYTEDEC);
	
	/*
	 * We currently don't try to interpret DVMRP packets...
	 */

	if (igmp.type != IGMP_TYPE_DVMRP)
	  display_ipv4("Group address", (u_int8_t *) &igmp.address);
      }
}


