/**************************************************************************** 
** File: ipx.c
**
** Author: Mike Borella
**
** Comments: Dump IPX header information
**
** $Log: ipx.c,v $
** Revision 1.4  2000/06/01 19:12:35  mborella
** Added minimal mode to SPX (not complete), added a little more support
** for ICMPv6 (also not complete)
**
** Revision 1.3  2000/06/01 18:36:55  mborella
** Made sure that all string maps are properly terminated, added TODO
** file, minor improvments to ICMPv6.
**
** Revision 1.2  2000/05/09 17:16:43  mborella
** Fixed new minimal more for IPX, IPX RIP and ARP.
**
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.3  2000/05/04 00:25:10  mborella
** Updated IPX for new API.  IPX RIP and SPX are now slightly broken.
** You've been warned...
**
** Revision 1.2  2000/04/16 23:28:46  mborella
** This is a major update, maoving the base IP stack protocols to the new
** generic reading and writing system.  Some stuff is still broken.
**
** Revision 1.1.1.1  2000/04/11 17:26:16  mborella
** Initial checkin of release 0.8.2 code.
**
** Revision 1.2  1998/06/12 21:01:08  mborella
** Added log tag
**
*****************************************************************************/

#include <stdio.h>
#include "global.h"
#include "protocols.h"

/*
 * IPX packet type map
 */

strmap_t ipx_packettype_map[] =
{
  { IPX_PACKETTYPE_UNKNOWN,        "unknown" },
  { IPX_PACKETTYPE_RIP,            "RIP" },
  { IPX_PACKETTYPE_ECHO,           "echo" },
  { IPX_PACKETTYPE_ERROR,          "error" },
  { IPX_PACKETTYPE_PEP,            "PEP" },
  { IPX_PACKETTYPE_SPX,            "SPX" },
  { IPX_PACKETTYPE_NCP,            "NCP" },
  { IPX_PACKETTYPE_NETBIOS,        "NetBIOS" },
  { 0, "" }
};

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_ipx()
**
** Parse IPX header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_ipx(packet_t *pkt)
{
  ipx_header_t ipx;
  char holder[64];
 
  /*
   * Get the IPX header
   */

  if (get_packet_bytes((u_int8_t *) &ipx, pkt, 30) == 0)
    return;

  /*
   * Conversions
   */

  ipx.csum = ntohs(ipx.csum);
  ipx.len = ntohs(ipx.len);
  ipx.dstnet = ntohl(ipx.dstnet);
  ipx.dstport = ntohs(ipx.dstport);
  ipx.srcnet = ntohl(ipx.srcnet);
  ipx.srcport = ntohs(ipx.srcport);

  /*
   * Dump header
   */
  
  if (my_args->m && !my_args->n)
    {
      display_minimal_string("IPX ");    
      display_minimal((u_int8_t *) &ipx.srcnode, 6, DISP_HEXCOLONS);
      display_minimal_string("->");
      display_minimal((u_int8_t *) &ipx.dstnode, 6, DISP_HEXCOLONS);
      display_minimal_string(" ");      
    }
  else 
    if (!my_args->n)
      {
	/* announcement */
	display_header_banner("IPX Header");
	
	/* Checksum, length, transport */
	display("Checksum", (u_int8_t *) &ipx.csum, 2, DISP_2BYTEDEC);
	display("Packet length", (u_int8_t *) &ipx.len, 2, DISP_2BYTEDEC);
	display("Transport control", (u_int8_t *) &ipx.tc, 1, DISP_1BYTEDEC);
	
	/* packet type */
	sprintf(holder, "%d (%s)", ipx.pt, 
		map2str(ipx_packettype_map, ipx.pt));
	display("Packet type", (u_int8_t *) holder, strlen(holder), 
		DISP_STRING);
	
	/* destination network information */
	display("Destination network", (u_int8_t *) &ipx.dstnet, 2, 
		DISP_4BYTEDEC);
	display("Destination node", (u_int8_t *) &ipx.dstnode, 6, 
		DISP_HEXCOLONS);
	display("Destination port", (u_int8_t *) &ipx.dstport, 2, 
		DISP_2BYTEDEC);
	
	/* source network information */
	display("Source network", (u_int8_t *) &ipx.srcnet, 2, 
		DISP_4BYTEDEC);
	display("Source node", (u_int8_t *) &ipx.srcnode, 6, 
		DISP_HEXCOLONS);
	display("Source port", (u_int8_t *) &ipx.srcport, 2, DISP_2BYTEDEC);
      }
  
  /*
   * Hand it to the next higher layer protocol.
   */
  
  switch (ipx.pt) 
    {
    case 1: 
      dump_ipxrip(pkt);
      break;
      
    case 5:
      dump_spx(pkt);
      break; 
      
    default:
      break;
    }
  
}
