/**************************************************************************** 
 **
 ** File: loopback.c
 **
 ** Author: Mike Borella
 **
 ** Comments: Dump loopback packets
 **
 *****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <pcap.h>
#include "global.h"
#include "protocols.h"

#define INET_FAMILY 524288

/*----------------------------------------------------------------------------
**
** dump_loopback()
**
** Process packets from DLT_NULL device
**
**----------------------------------------------------------------------------
*/

void dump_loopback(packet_t *pkt)
{
  u_int32_t family;
  char ann_str[64];

  /*
   * Dump header announcement
   */

  sprintf(ann_str, "%s (%s)", "Loopback header", pkt->timestamp);
  display_header_banner(ann_str);

  /*
   * Dump header field
   */

  get_packet_bytes((u_int8_t *) &family, pkt, 4);

  printf("Address family          ");
  if (family == INET_FAMILY)
    printf("Internet\n");
  else
    {
      printf("Unknown (%d)\n", family);
      return;
    }

  dump_ip(pkt);
  
  return;

}

