/**************************************************************************** 
** File: rip.h
**
** Author: Mike Borella
**
** Comments: Structure of RIP packets
**
** $Log: rip.h,v $
** Revision 1.3  2000/05/25 19:02:53  mborella
** Fixed RIP module to differentiate between RIP v1 and v2.
**
*****************************************************************************/

#ifndef RIP_H
#define RIP_H

/*
 * RIP commands
 */

#define RIP_CMD_RQ         1
#define RIP_CMD_RP         2
#define RIP_CMD_POLL       5
#define RIP_CMD_POLL_ENTRY 6

/*
 * Static part of RIP v1 header
 */

typedef struct ripv1_header
{
#if defined(WORDS_BIGENDIAN)
  u_int16_t  mbz;
  u_int8_t   version;
  u_int8_t   command;
#else
  u_int8_t   command;
  u_int8_t   version;
  u_int16_t  mbz;
#endif
} ripv1_header_t;

/*
 * RIP v1 route header
 */

typedef struct ripv1_route_header
{
  u_int16_t   addr_fam;
  u_int16_t   mbz1;
  u_int32_t   ipaddr;
  u_int8_t    mbz2[8];
  u_int32_t   metric;
} ripv1_route_header_t;

/*
 * Static part of RIP v2 header
 */

typedef struct ripv2_header
{
#if defined(WORDS_BIGENDIAN)
  u_int16_t  domain;
  u_int8_t   version;
  u_int8_t   command;
#else
  u_int8_t   command;
  u_int8_t   version;
  u_int16_t  domain;
#endif
} ripv2_header_t;

/*
 * RIP v2 route header
 */

typedef struct ripv2_route_header
{
  u_int16_t   addr_fam;
  u_int16_t   route_tag;
  u_int32_t   ipaddr;
  u_int32_t   netmask;
  u_int32_t   next_hop;
  u_int32_t   metric;
} ripv2_route_header_t;

/*
 * RIP v2 authentication header
 */

typedef struct ripv2_auth_header
{
  u_int16_t  addr_fam;
  u_int16_t  type;
  u_int8_t   passwd[16];
} ripv2_auth_header_t;

void dump_rip(packet_t *pkt);

#endif
