/**************************************************************************** 
** File: ripng.h
**
** Author: Mike Borella
**
** Comments: Structure of RIPng packets
**
** $Log: ripng.h,v $
** Revision 1.1  2000/06/19 23:10:34  mborella
** Adding RIPng support.
**
*****************************************************************************/

#ifndef RIPNG_H
#define RIPNG_H

/*
 * RIP commands
 */

#define RIPNG_CMD_RQ         1
#define RIPNG_CMD_RP         2

/*
 * Static part of RIPng header
 */

typedef struct ripng_header
{
#if defined(WORDS_BIGENDIAN)
  u_int16_t  mbz;
  u_int8_t   version;
  u_int8_t   command;
#else
  u_int8_t   command;
  u_int8_t   version;
  u_int16_t  mbz;
#endif
} ripng_header_t;

/*
 * RIPng route header
 */

typedef struct ripng_route_header
{
  u_int8_t   address[16];
  u_int16_t  route_tag;
  u_int8_t   netmask;
  u_int8_t   metric;
} ripng_route_header_t;

void dump_ripng(packet_t *pkt);

#endif
