/**************************************************************************** 
** File: slip.c
**
** Author: Michael S. Borella
**
** Comments: Dump slip packets
**
*****************************************************************************/

#include <stdio.h>
#include <pcap.h>
#include <unistd.h>
#include "global.h"
#include "protocols.h"

#define SLIP_HDRLEN 16

/*----------------------------------------------------------------------------
**
** dump_slip()
**
** Process packets from the DLT_RAW interface type
**
**----------------------------------------------------------------------------
*/

void dump_slip(packet_t *pkt)
{
  char ann_str[64];
  u_int8_t slip_header[SLIP_HDRLEN];

  /*
   * Dump header announcement
   */

  sprintf(ann_str, "%s (%s)", "Slip header", pkt->timestamp);
  display_header_banner(ann_str);

  /*
   * Get slip header
   */

  get_packet_bytes(slip_header, pkt, SLIP_HDRLEN);

  /*
   * XXX write something to dump SLIP fields here!
   */
  
  dump_ip(pkt);
}
