/**************************************************************************** 
 **
 ** File: slp.h
 **
 ** Author: Mike Borella
 **
 ** $Log: slp.h,v $
 ** Revision 1.1  2000/06/19 19:47:48  mborella
 ** Fixed SLP support, v1 seems to be working ok, v2 is not tested.  Also
 ** fixed bug in displaying routine for DISP_DEC.
 **
 *****************************************************************************/

#ifndef SLP_H
#define SLP_H

#define SLP_MSGTYPE_SRVRQST       1
#define SLP_MSGTYPE_SRVRPLY       2
#define SLP_MSGTYPE_SRVREG        3
#define SLP_MSGTYPE_SRVDEREG      4
#define SLP_MSGTYPE_SRVACK        5
#define SLP_MSGTYPE_ATTRRQST      6
#define SLP_MSGTYPE_ATTRRPLY      7
#define SLP_MSGTYPE_DAADVERT      8
#define SLP_MSGTYPE_SRVTYPERQST   9
#define SLP_MSGTYPE_SRVTYPERPLY   10
#define SLP_MSGTYPE_SAADVERT      11

/*
 * Fixed portion of SLPv1 header 
 */

typedef struct slpv1_header
{
  u_int8_t      version;
  u_int8_t      function_id;
  u_int16_t     length;
  u_int8_t      flags_rsrvd;
  u_int8_t      dialect;
  u_int16_t     lang_code;
  u_int16_t     char_encoding;
  u_int16_t     xid;
} slpv1_header_t;

/*
 * Fixed portion of SLPv2 header 
 */

typedef struct slpv2_header
{
  u_int8_t      version;
  u_int8_t      function_id;
  u_int8_t      length[3];
  u_int16_t     flags_rsrvd;
  u_int8_t      next_ext_offset[3];
  u_int16_t     xid;
  u_int16_t     lang_tag_length;
} slpv2_header_t;

void dump_slp(packet_t *);

#endif
