/**************************************************************************** 
** File: spx.h
**
** Author: Mike Borella
**
** Comments: Dump SPX header format and such
**
** $Log: spx.h,v $
** Revision 1.1  2000/05/04 19:11:42  mborella
** Moved a bunch of source files to the src directory.
**
** Revision 1.3  2000/05/04 18:21:10  mborella
** Fixed SPX.
**
** Revision 1.2  2000/05/04 00:25:10  mborella
** Updated IPX for new API.  IPX RIP and SPX are now slightly broken.
** You've been warned...
**
** Revision 1.1.1.1  2000/04/11 17:26:16  mborella
** Initial checkin of release 0.8.2 code.
**
** Revision 1.2  1998/06/12 20:48:13  mborella
** Added log tag
**
*****************************************************************************/

#ifndef SPX_H
#define SPX_H

typedef struct spx_header
{
  u_int8_t  cc;      /* connection control */
  u_int8_t  ds_type; /* data stream type */
  u_int16_t s_id;    /* source connection id */
  u_int16_t d_id;    /* destination connection id */
  u_int16_t seqno;   /* sequence number */
  u_int16_t ackno;   /* acknowledgement number */
  u_int16_t allocno; /* allocation number */
} spx_header_t;

void dump_spx(packet_t *);

#endif
