/**************************************************************************** 
** File: datalink.c
**
** Author: Mike Borella
**
** Comments: Generic datalink module
**
** $Log: datalink.c,v $
** Revision 1.7  2000/08/16 20:26:05  mborella
** Added basic hexbuffer support.  Tested with Ethernet, will add to other
** protocols.
**
** Revision 1.6  2000/05/21 15:26:41  mborella
** Added OSPF shim.  Doesn't actually work yet.  Also added autoconf hack
** that will look in several places for pcap.h.  Finally, added a few new
** IP protocols.
**
** Revision 1.5  2000/05/10 18:26:50  mborella
** Added TCP option support, cleaned up minimal mode, added TCP window
** advert to minimal mode, added timestamp to all lines in minimal mode.
**
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "global.h"
#include "protocols.h"
#include "error.h"
#include "datalink.h"

extern struct arg_t *my_args;
extern int packet_displayed;

/*----------------------------------------------------------------------------
**
** datalink()
**
**----------------------------------------------------------------------------
*/

void datalink(u_char *user, const struct pcap_pkthdr *h, u_char *pkt)
{
  packet_t packet;
  u_int16_t len;
  u_int32_t *link;

  /*
   * For minimal mode.  We haven't displayed part of a packet yet...
   */

  packet_displayed = 0;

  /*
   * Determine real length of the data that we received
   */

  len = h->caplen;

  /*
   * Set up packet into data structure
   */

  packet.contents = malloc(len+1);
  memcpy(packet.contents, pkt, len);
  packet.current = &packet.contents[0];
  packet.end = &packet.contents[0] + len;
  packet.media_length = h->len;
  sprintf(packet.timestamp, "%u.%06u", (u_int32_t) h->ts.tv_sec, 
	  (u_int32_t) h->ts.tv_usec);

  /*
   * If we're in minimal mode, start off with the packet timestamp
   */

  if (my_args->m)
    {
      display_minimal_string(packet.timestamp);
      display_minimal_string(" ");
    }

  /* 
   * Delete any remaining hex buffer contents
   */

  hexbuffer_kill();

  /*
   * Determine what to do next
   */

  link = (u_int32_t *) user;
  switch(*link)
    {
    case DLT_NULL:
      dump_loopback(&packet);
      break;

    case DLT_EN10MB:
      dump_ethernet(&packet);
      break;

    case DLT_SLIP:
      dump_slip(&packet);
      break;

#ifdef DLT_RAW /* Not supported in some arch or older pcap versions */
    case DLT_RAW:
      dump_raw(&packet);
      break;
#endif
    default:
      GWF_error_fatal("\ncannot handle data link type %d", link);
    }

  /*
   * Deallocate memory
   */

  free(packet.contents);

  /*
   * For minimal mode, finish with a carriage return
   */

  if (my_args->m && packet_displayed)
    {
      display_minimal("\n", 1, DISP_STRING);
    }

}
