/**************************************************************************** 
** File: display.h
**
** Author: Mike Borella
**
** Comments: Header file for displaying functions
** 
** $Id: display.h,v 1.11 2000/08/16 20:26:05 mborella Exp $
**
*****************************************************************************/

#ifndef DISPLAY_H
#define DISPLAY_H

#include <sys/types.h>
#include "global.h"

/*
 * Display format types
 */

typedef enum display
{
  DISP_1BYTEDEC,     /* 1 byte, decimal format (12) */
  DISP_2BYTEDEC,     /* 2 bytes, decimal format (10, 5) */
  DISP_4BYTEDEC,     /* 4 bytes, decimal format (10, 5, 234234) */
  DISP_DEC,          /* Display and arbitrary decimal value */
  DISP_BIN,          /* Binary format with leading 0's (01101110) */
  DISP_BINNLZ,       /* Binary format w/o leading 0's (1101110) */
  DISP_HEX,          /* 2 bytes, hex (0F) */
  DISP_HEXCOLONS,    /* Hex bytes separated by colons (0F:7A:B1) */
  DISP_HEXCOLONS4,   /* 4 Hex bytes between colons */
  DISP_DOTTEDDEC,    /* Dotted decimal (IP address) format (4 bytes only) */
  DISP_STRING        /* Plain old ascii string */
} display_t;

/*
 * Function prototypes
 */

inline void reverse_byte_order(u_int8_t *, int);
inline void display_header_line_dashes (void);
inline void display_header_line_equals (void);
inline void display_header_line_dots (void);
inline void display_header_banner (char *);
inline void display (char *, u_int8_t *, u_int8_t, display_t);
inline void display_string (u_int8_t *, u_int8_t *);
inline void display_ipv4 (u_int8_t *, u_int8_t *);
inline void display_ipv6 (u_int8_t *, u_int8_t *);
inline void display_minimal (u_int8_t * content, u_int8_t length, 
			    display_t format);
inline void display_minimal_string (u_int8_t *);
inline void display_minimal_ipv4 (u_int8_t *);
inline void display_minimal_ipv6 (u_int8_t *);

#endif
