/**************************************************************************** 
 ** File: dns.h
 **
 ** Author: Mike Borella
 **
 ** Comments: Structure of the first 12 bytes of DNS packets
 **
 ** $Id: dns.h,v 1.7 2000/08/16 21:14:05 mborella Exp $
 **
 ****************************************************************************/

#ifndef DNS_H
#define DNS_H

#include "global.h"

typedef struct dns_header
{
  u_int16_t id;
#if defined (WORDS_BIGENDIAN)
  u_int16_t flag_qr:1,
            flag_opcode:4,
            flag_aa:1,
            flag_tc:1,
            flag_rd:1,
            flag_ra:1,
            flag_zero:3,
            flag_rcode:4;
#else
  u_int16_t flag_rcode:4,
            flag_zero:3,
            flag_ra:1,
            flag_rd:1,
            flag_tc:1,
            flag_aa:1,
            flag_opcode:4,
            flag_qr:1;
#endif
  u_int16_t number_questions;
  u_int16_t number_answers;
  u_int16_t number_authority;
  u_int16_t number_additional;
} dns_header_t;

/*
 * Query/response flag
 */

#define DNS_QRFLAG_QUERY        0
#define DNS_QRFLAG_RESPONSE     1

/*
 * Opcode flag
 */

#define DNS_OPCODEFLAG_STANDARD     0
#define DNS_OPCODEFLAG_INVERSE      1
#define DNS_OPCODEFLAG_STATUS       2

/*
 * Rcode (return code) flag
 */

#define DNS_RCODEFLAG_NOERROR        0
#define DNS_RCODEFLAG_FORMATERROR    1
#define DNS_RCODEFLAG_SERVERERROR    2
#define DNS_RCODEFLAG_NAMEERROR      3
#define DNS_RCODEFLAG_NOTIMPLEMENTED 4
#define DNS_RCODEFLAG_SERVICEREFUSED 5

/*
 * Query type
 */

#define DNS_QUERYTYPE_A              1
#define DNS_QUERYTYPE_NS             2
#define DNS_QUERYTYPE_CNAME          5
#define DNS_QUERYTYPE_SOA            6
#define DNS_QUERYTYPE_PTR            12
#define DNS_QUERYTYPE_HINFO          13
#define DNS_QUERYTYPE_MX             15
#define DNS_QUERYTYPE_AAAA           28
#define DNS_QUERYTYPE_AXFR           252
#define DNS_QUERYTYPE_ANY            255

/*
 * Query class
 */

#define DNS_QUERYCLASS_IP            1

void dump_dns(packet_t *);

#endif

