/**************************************************************************** 
** File: hexbuffer.h
**
** Author: Mike Borella
**
** Header file for hex buffer manipulation.  The hex buffer holds
** all of the bytes read since the last time the hex buffer was flushed.
** When the hex buffer is flushed, all bytes are displayed in hex and 
** (printable) ascii format to the screen, preceeded by a dotted line.
**
*****************************************************************************/

#ifndef HEXBUFFER_H
#define HEXBUFFER_H

#include "global.h"

inline void hexbuffer_add(u_int8_t *ptr, int length);
inline void hexbuffer_flush(void);
inline void hexbuffer_kill(void);
#endif
