/**************************************************************************** 
** File: ipv6.h
**
** Author: Mike Borella
**
** Comments: Generic IPv6 header structure.
**
** $Id: ipv6.h,v 1.6 2000/08/16 21:14:05 mborella Exp $
**
*****************************************************************************/

#ifndef IPV6_H
#define IPV6_H

#include "global.h"

typedef struct ipv6_header
{
#if defined(WORDS_BIGENDIAN)
  u_int8_t       version:4, 
                 traffic_class_high:4;
  u_int8_t       traffic_class_low:4,
                 flow_label_high:4;
#else
  u_int8_t       traffic_class_high:4,
                 version:4;
  u_int8_t       flow_label_high:4,
                 traffic_class_low:4;
#endif
  u_int16_t      flow_label_low;
  u_int16_t      payload_length;
  u_int8_t       next_header;
  u_int8_t       hop_limit;
  u_int8_t       src_addr[16];
  u_int8_t       dst_addr[16];
} ipv6_header_t;

void dump_ipv6(packet_t *);

#endif
