/**************************************************************************** 
** File: isakmp.h
**
** Author: Mike Borella
**
** Comments: Structure of ISAKMP packets
**
*****************************************************************************/

#define DOI_IPSEC 1


/*
 * Situation definitions for IPSEC DOI
 */

#define SIT_IDENTITY_ONLY 0x01
#define SIT_SECRECY       0x02
#define SIT_INTEGRITY     0x04


/*
 * Static part of ISAKMP header
 */

typedef struct _ISAKMPHdr
{
  char i_cookie[8];
  char r_cookie[8];
#if defined(WORDS_BIGENDIAN)
  u_int32_t flags:8,
            exchange_type:8,
            min_version:4,
            maj_version:4,
            next_payload:8;
#else
  u_int32_t next_payload:8,
            maj_version:4,
            min_version:4,
            exchange_type:8,
            flags:8;
#endif
  u_int32_t msg_id;
  u_int32_t length;
  
} ISAKMPHdr;

/*
 * ISAKMP Generic Payload Header
 */

typedef struct _ISAKMP_generic_hdr
{
#if defined(WORDS_BIGENDIAN)
  u_int32_t length:16,
            reserved:8,
            next_payload:8;
#else
  u_int32_t next_payload:8,
            reserved:8,
            length:16;
#endif
} ISAKMP_generic_hdr;


void dump_isakmp(u_char *bp, int length);
